#!/usr/bin/env bash

file_hosts="hosts.yml"
file_vars="variables.yml"

hosts=$(grep -w "ansible_host:" $file_hosts | cut -d " " -f8)
hostnames=$(grep -w "machine_hostname:" $file_hosts | cut -d " " -f8 | sed 's/"//' | sed 's/"//')
domain=$(grep -w "domain:" $file_vars | cut -d " " -f2 | sed 's/"//' | sed 's/"//')
zone=$(grep -w "zone:" $file_vars | cut -d " " -f2 | sed 's/"//' | sed 's/"//')
publish=$(grep -w "publish:" $file_vars | cut -d " " -f2 | sed 's/"//' | sed 's/"//')

hosts_lenght=$(echo -e "$hosts" | wc -l)
hostnames_lenght=$(echo -e "$hostnames" | wc -l)

x=$hosts_lenght

echo "---"

echo "The installation should be succesfull, you can now add these entries to your dns:"

echo "---"

while [ $x -gt 0 ];
do
  host=""
  hostname=""
  host=$(echo -e "$hosts" | sed -n "$x"p)
  hostname=$(echo -e "$hostnames" | sed -n "$x"p)
  echo "$hostname 300 IN A $host"
  echo "$zone 300 IN NS $hostname.$domain."
  x=$(($x-1))
done

echo "---"

echo "to publish something like www.$domain via your new geo-balancer, add this to your dns config:"
echo "www 900 IN CNAME $publish.$zone.$domain."

echo "---"
